//---------------------------------------------------------------------------------------
/*!
	@file	CA2DSDKAPI.h
	@author	KONICA MINOLTA, INC.
			Copyright(c) KONICA MINOLTA, INC.  All rights reserved. 2013
*/
//---------------------------------------------------------------------------------------
#ifndef CA2DSDK_API_H__
#define CA2DSDK_API_H__

#include "CA2DTypeDefine.h"
#include "CA2Dcommon.h"

#if defined(__cplusplus)
extern "C"{
#endif

CA2DSDK_ER KMAPI CA2DSDK_Enable();
CA2DSDK_ER KMAPI CA2DSDK_Disable();

CA2DSDK_ER KMAPI CA2DSDK_ConnectInstrument(int32_km index);
CA2DSDK_ER KMAPI CA2DSDK_DisconnectInstrument();
CA2DSDK_ER KMAPI CA2DSDK_IsConnectInstrument();
CA2DSDK_ER KMAPI CA2DSDK_GetInstrumentCount();
CA2DSDK_ER KMAPI CA2DSDK_GetInstrumentSerialNumber(int32_km index);

CA2DSDK_ER KMAPI CA2DSDK_SetInstrumentCondition(const tagInstrumentCond* pInstCond);
CA2DSDK_ER KMAPI CA2DSDK_GetInstrumentCondition(tagInstrumentCond* pInstCond);
CA2DSDK_ER KMAPI CA2DSDK_SetUserCalibrationData(const tagUserCalData* pUserCal);
CA2DSDK_ER KMAPI CA2DSDK_GetUserCalibrationData(tagUserCalData* pUserCal);

CA2DSDK_ER KMAPI CA2DSDK_DoMeasurement();
CA2DSDK_ER KMAPI CA2DSDK_PollingMeasurement();
CA2DSDK_ER KMAPI CA2DSDK_StopMeasurement();
CA2DSDK_ER KMAPI CA2DSDK_GetAreaData(const tagGetDataParam* pDataParam, float* pData);
CA2DSDK_ER KMAPI CA2DSDK_SetDataCondition(const tagDataCond* pDataCond);
CA2DSDK_ER KMAPI CA2DSDK_GetDataCondition(tagDataCond* pDataCond);

CA2DSDK_ER KMAPI CA2DSDK_ClearEvaluationArea();
CA2DSDK_ER KMAPI CA2DSDK_SetEvaluationAreaCondition(const tagEvaluationCond* pCond);
CA2DSDK_ER KMAPI CA2DSDK_GetEvaluationAreaCondition(tagEvaluationCond* pCond);
CA2DSDK_ER KMAPI CA2DSDK_AddEvaluationArea(const tagEvaluationArea* pArea);
CA2DSDK_ER KMAPI CA2DSDK_GetEvaluationAreaCount(int32_km* pCount);
CA2DSDK_ER KMAPI CA2DSDK_GetEvaluationArea(int num, tagEvaluationArea* pArea);
CA2DSDK_ER KMAPI CA2DSDK_SetAlignedSpotCondition(const tagAlignedSpotCond* pCond);
CA2DSDK_ER KMAPI CA2DSDK_GetAlignedSpotCondition(tagAlignedSpotCond* pCond);
CA2DSDK_ER KMAPI CA2DSDK_CalculateSpotValue();
CA2DSDK_ER KMAPI CA2DSDK_GetSpotValue(int32_km num, int32_km point, tagSpotValue* pResult);

CA2DSDK_ER KMAPI CA2DSDK_DiagnosisInstrument();
CA2DSDK_ER KMAPI CA2DSDK_PollingDiagnosis();
CA2DSDK_ER KMAPI CA2DSDK_StopDiagnosis();
CA2DSDK_ER KMAPI CA2DSDK_GetDiagnosisDate(tagDate *pDate);
CA2DSDK_ER KMAPI CA2DSDK_GetFinderImage(short* pData);
CA2DSDK_ER KMAPI CA2DSDK_CheckPeriodicalCalibration(tagPeriodicalCalInfo* pInfo);
int32_km KMAPI CA2DSDK_GetSDKVersion();

#ifdef LABVIEW
CA2DSDK_ER KMAPI CA2DSDK_GetUserCalibrationData_l(int16_km* pCaltype, double_km* pR, double_km* pG, double_km* pB, double_km* pW);
CA2DSDK_ER KMAPI CA2DSDK_SetUserCalibrationData_l(const int16_km caltype, const double_km* pR, const double_km* pG, const double_km* pB, const double_km* pW);
#endif

#if defined(__cplusplus)
}
#endif

#endif //CA2DSDK_API_H__